--[[
	Sarf's SemiAutoRecast script v0.3 - 2004-06-24 14:29 GMT+2
	Based on code by wonderful. 
	This is simply a refactoring of wonderful's code to make it easier to extend.

	wonderful's original post : http://www.worldofwarcraft.com/thread.aspx?FN=wow-interface-customization&T=3383
	To make this script work, you should follow wonderful's steps 1 to 3,
	replace the code in step 4 with the code below, then complete step 4 and 5.
	
	I recommend adding the function call to MOVEBACKWARD and MOVEFORWARD, too, 
	but that's just me. :)
]]--

--]]
	AUTORECAST_ACTIONBARNUMBER, AUTORECAST_ACTIONBARKEYNUMBER and 
	AUTORECAST_WAIT must all have the same number of elements.
	The reason for this is that each "column" of the three tables 
	make up the instructions for how to cast the spells in question.
	
	It is suggested that the number of elements of these three tables is 
	equal to AUTORECAST_MAXINDEX, but as long as it is not fewer elements,
	it will work fine. It can (and should) be replaced by a 
	getNumberOfElementsOfTable() function, but I don't know enough about lua 
	to know what it is called, or even if there is one.
	
	Note: You should place the spell/ability with the least duration FIRST,
	as the code will iterate through the tables and wait the specified time 
	between each new "cast"
]]--


-- The autorecast action bar numbers - what keybar to switch to
AUTORECAST_ACTIONBARNUMBER = { 6, 6 };
-- The autorecast action bar key numbers - what keys to press on the keybar 
AUTORECAST_ACTIONBARKEYNUMBER = { 11, 12 };
-- The autorecast wait - how long to wait until going to the next autorecast
AUTORECAST_WAIT = { 2, 150 };

-- the number of autorecasts you have
AUTORECAST_MAXINDEX = 2;

-- which index the AUTORECAST should use the next time
AUTORECAST_CURRENTINDEX = 1;
-- contains the time when the next autorecast should be done
AUTORECAST_CURRENTWAIT = 0;

-- to remain backwards compatible
function SemiAutoRecast()
	SemiAutoRecast();
end

-- will reset the AutoRecast so that it starts fresh
function SemiAutoRecastReset()
	AUTORECAST_CURRENTINDEX = 1;	
	AUTORECAST_CURRENTWAIT = 0;
	-- perhaps do a recast?
	-- SemiAutoRecast();
end

-- checks if it is time to auto recast something, 
-- and tries to do so if the time is right
function SemiAutoRecast()
        local time = GetTime();
        if ( IN_ATTACK_MODE == 0 and ( time > AUTORECAST_CURRENTWAIT ) ) then
                local curBar = CURRENT_ACTIONBAR_PAGE;

		-- prevents unnecessary action bar switching
                if(curBar ~= AUTORECAST_ACTIONBARNUMBER[AUTORECAST_CURRENTINDEX] ) then
			CURRENT_ACTIONBAR_PAGE = AUTORECAST_ACTIONBARNUMBER[AUTORECAST_CURRENTINDEX];
  	            	ChangeActionBarPage();
  	        end

                ActionButtonDown( AUTORECAST_ACTIONBARKEYNUMBER[AUTORECAST_CURRENTINDEX] );
                ActionButtonUp( AUTORECAST_ACTIONBARKEYNUMBER[AUTORECAST_CURRENTINDEX] );

		AUTORECAST_CURRENTWAIT = time + AUTORECAST_WAIT[AUTORECAST_CURRENTINDEX];
  	            
		AUTORECAST_CURRENTINDEX = AUTORECAST_CURRENTINDEX + 1;
  	            
		if(AUTORECAST_CURRENTINDEX > AUTORECAST_MAXINDEX) then
  	            	AUTORECAST_CURRENTINDEX = 1;
  	        end

		-- prevents unnecessary action bar switching
                if(curBar ~= CURRENT_ACTIONBAR_PAGE ) then
	              CURRENT_ACTIONBAR_PAGE = curBar;
  	              ChangeActionBarPage();
  	        end
        end
end
